#include common_scripts\utility;
#include maps\mp\_utility;

init()
{
	level thread onPlayerConnect();
}

onPlayerConnect()
{
	for(;;)
	{
		level waittill( "connected", player );
		player.loudout = [];
		if(!level.QuickSetup){
			level.QuickSetup = true;
			level thread assignRandomWeapons();
		}
		player thread onPlayerSpawned();
	}
}

onPlayerSpawned()
{
	self endon( "disconnect" );
	for(;;)
	{
		self waittill( "spawned_player" );
		self thread setupPlayer();
	}
}

testMode(){
	for(;;){
		self iPrintLn(self getCurrentWeapon());
		wait 1;
	}
}

setupPlayer(){
	//self thread antiHardscope();
	//self thread antiSpamFire();
	//self thread testMode();
	if(!self validWeapon(self getCurrentWeapon())){
		self takeAllWeapons();
		self _clearPerks();
		self giveQuickPerks();
		self giveRandomWeapons();
		self thread checkOffhands();
	}
	wait 0.1;
	self giveExtraPerks();
	self thread checkWeapons();
}
giveQuickPerks(){
	maps\mp\_utility::givePerk("specialty_bulletdamage", 0);
	maps\mp\_utility::givePerk("specialty_armorpiercing", 0);
	maps\mp\_utility::giveperk("specialty_fastreload", 0 );
	maps\mp\_utility::giveperk("specialty_quickdraw", 0 );
}

giveExtraPerks(){
	maps\mp\_utility::givePerk("specialty_bulletaccuracy", 0);
	maps\mp\_utility::giveperk("specialty_scavenger", 0 );
}

checkoffhands(){
	self endon("death");
	self endon("disconnect");
	while(1){
		if(!self hasWeapon("iw9_throwknife_mp") || !self hasWeapon("h1_flashgrenade_mp")){
			self setlethalweapon("iw9_throwknife_mp");
			self maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			self setWeaponAmmoClip("iw9_throwknife_mp", 1);
			self settacticalweapon("h1_flashgrenade_mp");
			self maps\mp\gametypes\_class::giveoffhand("h1_flashgrenade_mp");
			self setWeaponAmmoClip("h1_flashgrenade_mp", 2);
		}
		wait 0.025;
	}
}

giveRandomWeapons(){
	pWeapon = getRandomAttachments(level.weapon_quickscope[randomint(level.weapon_quickscope.size)]);
	var_0 = randomInt(2);
	if(var_0 == 0)
		sWeapon = getRandomAttachments(level.weapon_pistols[randomint(level.weapon_pistols.size)]);
	else
		sWeapon = getRandomAttachments(level.weapon_secondary_shotguns[randomint(level.weapon_secondary_shotguns.size)]);
	self.loudout["weapons"]["primary"] = getWeaponFullName(pWeapon, randomint(46));
	self.loudout["weapons"]["secondary"] = getWeaponFullName(sWeapon, randomint(46));
	self _giveWeapon(self.loudout["weapons"]["primary"]);
	self _giveWeapon(self.loudout["weapons"]["secondary"]);
	wait 0.1;
	self switchToWeapon(self.loudout["weapons"]["primary"]);
}

antiSpamFire()
{
	self endon( "disconnect" );
	self endon( "death" );
	adstimer = 0;
	for(;;)
	{
		if(self attackButtonPressed()) 
		{
			adstimer ++;
			//self iPrintLn(adstimer);
		}
		else 
		{
			adstimer = 0;
		}
		//iPrintLn(adstimer);
		if(adstimer >= 18) 
		{
			adstimer = 0;
			self forceUnADS();
		}
		wait 0.025;
	}
}

antiHardscope()
{
	if(!isDefined(self.holdADS))
		self.holdADS = false;
	if(!isDefined(self.toggleADS))
		self.toggleADS = false;
	self notifyonplayercommand( "pressedToggleADS", "+toggleads_throw" );
	self notifyonplayercommand( "pressedADS", "+speed_throw" );
	self notifyonplayercommand( "unpressedToggleADS", "-toggleads_throw" );
	self notifyonplayercommand( "unpressedADS", "-speed_throw" );
	self thread monitorToggleADS();
	self thread monitorHoldADS();

	self thread antiHardscope2();
}

monitorToggleADS(){
	self endon( "disconnect" );
	self endon( "death" );
	while(1){
		self waittill("pressedToggleADS");
		self.toggleADS = true;
		self.holdADS = false;
	}
}

monitorHoldADS(){
	self endon( "disconnect" );
	self endon( "death" );
	while(1){
		self waittill("pressedADS");
		self.holdADS = true;
		self.toggleADS = false;
	}
}

monitorHoldADSPresses(){
	self endon( "disconnect" );
	self endon( "death" );
	while(1){
		self waittill("pressedToggleADS");
		self thread setIfADS();
	}
}

setIfADS(){
	self.isADsToggled = true;
	while(self playerAds())
		wait 0.025;
	self.isADsToggled = false;
}

antiHardscope2(){
	self endon( "disconnect" );
	self endon( "death" );
	adstimer = 0;
	for(;;)
	{
		if(self.holdADS && !self.toggleADS){
			if(self adsButtonPressed() && !self fragButtonPressed() && !self secondaryOffhandButtonPressed() && maps\mp\_utility::getweaponclass(self getCurrentWeapon()) == "weapon_sniper") 
			{
				adstimer ++;
			}
			else 
			{
				adstimer = 0;
			}
			if(adstimer >= 18) 
			{
				adstimer = 0;
				//self forceUnADS();
				self allowAds(false);
				while(!self adsButtonPressed()){
					self iPrintLn("Not Pressed");
					wait 0.025;
				}
					
				self allowAds(true);
			}
		}
		else if(!self.holdADS && self.toggleADS){
			if(self playerAds() && maps\mp\_utility::getweaponclass(self getCurrentWeapon()) == "weapon_sniper") 
			{
				adstimer ++;
			}
			else 
			{
				adstimer = 0;
			}
			//self iPrintLn(self.pers["toggleScopeStates"][self getCurrentWeapon()]);
			if(adstimer >= 25) 
			{
				adstimer = 0;
				//self forceUnADS();
				self allowFire(false);
				while(self playerAds())
					wait 0.025;
				self allowFire(true);
			}
		}
		wait 0.025;
	}
}

forceUnADS(){
	stock = self getWeaponAmmoStock(self getCurrentWeapon());
	clip = self getWeaponAmmoClip(self getCurrentWeapon());
	weapon = self getCurrentWeapon();
	self takeWeapon(weapon);
	self _giveWeapon(weapon);
	self setWeaponAmmoClip(weapon, clip);
	self setWeaponAmmoStock(weapon, stock);
	wait 0.1;
	self switchToWeapon(weapon);
}

checkWeapons()
{
	self endon( "disconnect" );
	self endon("death");
	while(1){
		weapon = self getCurrentWeapon();
		class = maps\mp\_utility::getweaponclass(weapon);
		if(!self validWeapon(weapon) && weapon != "" && weapon != "none" && weapon != undefined && !self adsButtonPressed() && !self fragButtonPressed() && !self secondaryOffhandButtonPressed()){
			self takeWeapon(weapon);
			if(class == "weapon_secondary_machine_pistol" || class == "weapon_secondary_shotgun"){
				var_0 = randomInt(2);
				if(var_0 == 0)
					sWeapon = getRandomAttachments(level.weapon_pistols[randomint(level.weapon_pistols.size)]);
				else
					sWeapon = getRandomAttachments(level.weapon_secondary_shotguns[randomint(level.weapon_secondary_shotguns.size)]);
				self.loudout["weapons"]["secondary"] = getWeaponFullName(sWeapon, randomint(46));
				self _giveWeapon(self.loudout["weapons"]["secondary"]);
				wait 0.1;
				self switchToWeapon(self.loudout["weapons"]["secondary"]);
			}
			else{
				pWeapon = getRandomAttachments(level.weapon_quickscope[randomint(level.weapon_quickscope.size)]);
				self.loudout["weapons"]["primary"] = getWeaponFullName(pWeapon, randomint(46));
				self _giveWeapon(self.loudout["weapons"]["primary"]);
				wait 0.1;
				self switchToWeapon(self.loudout["weapons"]["primary"]);
			}
		}
		wait 0.025;
	}
}

assignRandomWeapons(){
	level.loudout = [];
	level.weapon_secondary_shotguns = [];
	level.weapon_snipers = [];
	level.weapon_quickscope = [];
	level.weapon_heavys = [];
	level.weapon_smgs = [];
	level.weapon_assaults = [];
	level.weapon_secondary_machine_pistols = [];
	level.weapon_pistols = [];
	foreach(weapon in level.weaponList){
		switch(maps\mp\_utility::getweaponclass(weapon)){
			case "weapon_secondary_shotgun":
				level.weapon_secondary_shotguns[level.weapon_secondary_shotguns.size] = weapon;
				level.weapon_secondary_shotguns++;
			break;
			case "weapon_sniper":
				if(canQuickScope(weapon)){
					level.weapon_quickscope[level.weapon_quickscope.size] = weapon;
					level.weapon_quickscope++;
				}
				level.weapon_snipers[level.weapon_snipers.size] = weapon;
				level.weapon_snipers++;
			break;
			case "weapon_heavy":
				level.weapon_heavys[level.weapon_heavys.size] = weapon;
				level.weapon_heavys++;
			break;
			case "weapon_smg":
				level.weapon_smgs[level.weapon_smgs.size] = weapon;
				level.weapon_smgs++;
			break;
			case "weapon_assault":
				level.weapon_assaults[level.weapon_assaults.size] = weapon;
				level.weapon_assaults++;
			break;
			case "weapon_secondary_machine_pistol":
				level.weapon_secondary_machine_pistols[level.weapon_secondary_machine_pistols.size] = weapon;
				level.weapon_secondary_machine_pistols++;
			break;
			case "weapon_pistol":
				level.weapon_pistols[level.weapon_pistols.size] = weapon;
				level.weapon_pistols++;
			break;
		}
	}
}

getWeaponFullName(weapon, camo){
    if(camo == 0 || weapon == "none" || weapon == "")
        return weapon;
    else if(camo > 0 && camo < 10)
        return weapon+"_camo00"+camo;
    else if(camo >= 10 && camo < 100)
        return weapon+"_camo0"+camo;
    else if(camo >= 100)
        return weapon+"_camo"+camo;
}

getRandomAttachments(weapon){
	var_0 = "";
	var_1 = "";
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_sniper":
			switch(randomint(4)){
				case 0:
					var_0 = "fmj";
				break;
				case 1:
					var_0 = "silencersniper";
				break;
				case 2:
					var_0 = "xmag";
				break;
				case 3:
					var_0 = "silencersniper_xmag";
				break;
			}
		break;
		case "weapon_pistol":
			switch(randomint(4)){
				case 0:
					if(isSubStr( weapon, "h2_usp_mp" ))
						var_0 = "tacknifeusp";
					else if(isSubStr( weapon, "h2_deserteagle_mp" ))
						var_0 = "tacknifedeagle";
					else if(isSubStr( weapon, "h2_colt45_mp" ))
						var_0 = "tacknifecolt45";
					else if(isSubStr( weapon, "h2_m9_mp" ))
						var_0 = "tacknifem9";
				break;
				case 1:
					if(isSubStr( weapon, "h2_usp_mp" ))
						var_0 = "tacknifeusp";
					else if(isSubStr( weapon, "h2_deserteagle_mp" ))
						var_0 = "tacknifedeagle";
					else if(isSubStr( weapon, "h2_colt45_mp" ))
						var_0 = "tacknifecolt45";
					else if(isSubStr( weapon, "h2_m9_mp" ))
						var_0 = "tacknifem9";
				break;
				case 2:
					var_0 = "akimbo_xmag";
				break;
				case 3:
					var_0 = "akimbo_silencerpistol";
				break;
			}
		break;
	}
	if(var_0 != "")
		return weapon+"_"+var_0;
	else
		return weapon;
}

canQuickScope(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_barrett_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

isBoltAction(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

canDoAkimbo(weapon){
	if(
		weapon == "h2_glock_mp" ||
		weapon == "h2_beretta393_mp" ||
		weapon == "h2_tmp_mp"
	)
		return true;
	else
		return false;
}

canDoSilencer(weapon){
	if(
		weapon == "h2_coltanaconda_mp"
	)
		return false;
	else
		return true;
}

validWeapon(weapon)
{
	valid = false;
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_secondary_shotgun":
			valid = true;
		break;
		case "weapon_sniper":
			valid = true;
		break;
		case "weapon_pistol":
			valid = true;
		break;
		default:
			valid = false;
		break;
	}
	return valid;
}